/**
 * 
 */
var Parser = (function(){

	/**
	 * returns text value of first element for defined tag
	 * @param {Node} elem
	 * @param {String} tag name
	 * @return {Mixed} string value of node if exist or false otherwise 
	 * */
	function getTxtByTag(elem,tag) {
		var items = [],
			val = false;
		if( tag ) {
			items = elem.getElementsByTagName(tag);
		}
		if( items.length ){
			val = items[0].text ? items[0].text : items[0].textContent;
		}
		return val;
	}
	
	/**
	 * 
	 * */
	function parseChannel(xml){
		
		var img = null,
			description ='',
			title = '',
			channel,
			chanelData = {},
			img;
		
		channel = xml.getElementsByTagName( 'channel' );
		if( channel.length ) {
			description = getTxtByTag(channel[0], 'description');
			title       = getTxtByTag(channel[0], 'title');
			var imgs = channel[0].getElementsByTagName( 'image' );
			if( imgs.length ){
				img = getTxtByTag( imgs[0], 'url' ); 
			}
		}
		else if( xml.documentElement && xml.documentElement.nodeName == 'feed') {
			description = getTxtByTag( xml, 'subtitle');
			title       = getTxtByTag( xml, 'title');
			img 		= getTxtByTag( xml, 'icon' ); 
		}
		
		chanelData = {
			icon: img,
			description: description,
			title: title
		};
		
		return chanelData;
	}
	
	/**
	 * parser returns list of items
	 * */
	function parse(xml) {
		
		var atom;
		var ret = [];
		
		if( xml.getElementsByTagName('channel').length ){
			atom = false;
		}
		else if( xml.documentElement && xml.documentElement.nodeName == 'feed') {
			atom = true;
		}
		else {
			throw {message: 'Wrong format'};
		}
		
		var items = atom ? xml.getElementsByTagName( 'entry' ) : xml.getElementsByTagName( 'item' );
		for (var i = 0; i < items.length; i++) {
			var item = parseItem( items[i ], atom );
			ret.push(item);
		}
		return ret;
	}
	
	/**
	 * parser returns list of channels
	 * @param {String} txt 
	 * @return {Array} with feeds
	 * */
	function parseChannels(txt) {
		
		var domParser, xml;
		
		try {
			domParser = new DOMParser();
			xml = domParser.parseFromString(txt, "application/xml");
		} catch( err ){
			throw {message: 'No channels imported.'};
		}
	
		var root = xml.documentElement.nodeName;
		if( 'parsererror' == root || 'opml' != root ) {
			throw {message: 'Invalid file format. Only OPML files supported.'};
		}
		
		var channels = xml.getElementsByTagName('outline'),
			ret = [],
			feed;

		if( channels.length ) {
			for (var i = 0; i < channels.length; i++) {
				var url = channels[i].getAttribute( 'xmlUrl' );
				var title = channels[i].getAttribute( 'text' );
				
				if( url && url != '' ) {
					feed = new Feed( url, { color: 'rgba( 155,0,0, ' + (0.5+(Math.random()/2)) +')', title: title }  );
					ret.push(feed);
				}
			}
				
		}
		else {
			throw {message: 'No channels imported.'};
		}

		return ret;
	}
	
	/**
	 * parsers item element
	 * */
	function parseItem(item, atom) {
		
		var atom = atom || false;
		var title,
			link,
			id,
			content,
			pubDate;
		
		if( atom ) {
		
			id 		= getTxtByTag(item, 'id');
			title 	= getTxtByTag( item, 'title');
			pubDate = new Date( getTxtByTag(item,'updated') || getTxtByTag(item,'modified') );
			content = getTxtByTag(item,'content') || getTxtByTag(item,'summary');
				
			var links = item.getElementsByTagName('link');
			link = null;
			for (var i = 0; i < links.length; i++) {
				var rel = links[i].getAttribute('rel');
				if ( !rel || rel == 'alternate') { 
					link = links[i].getAttribute('href'); 
					break;
				}
			}
		}
		
		else {
			title 	= getTxtByTag(item, 'title');
			link  	= getTxtByTag(item, 'link' );
			id    	= getTxtByTag(item, 'guid' );
			content = getTxtByTag(item, 'description') || getTxtByTag(item, 'content');
			content = content.replace(/<br\/>/gi, " ");
			pubDate = new Date( getTxtByTag( item, 'date') || getTxtByTag(item,'pubDate') );
		}		
		var item = new Item({ 
			id: id, 
			title: title, 
			content: content, 
			url: link, 
			pubDate: pubDate 
		});
		
		return item;
	}
	
	return {
		
		getItems: parse,
		
		getChannelData: parseChannel,
		
		getChannels: parseChannels
	}
})();
